<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl">
<head>
	<title>Prosty skrypt galerii zdjęć z efektem Highslide - wersja 2</title>
	<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
	<script type="text/javascript" src="javascript/highslide-with-gallery.js"></script>
	<link rel="stylesheet" href="css/style.css" type="text/css" media="screen" />
<script type="text/javascript">
	hs.graphicsDir = 'javascript/images/';
	hs.align = 'center';
	hs.transitions = ['expand', 'crossfade'];
	hs.outlineType = 'rounded-white';
	hs.fadeInOut = true;
	//hs.dimmingOpacity = 0.75;

	// Add the controlbar
	if (hs.addSlideshow) hs.addSlideshow({
		//slideshowGroup: 'group1',
		interval: 5000,
		repeat: false,
		useControls: true,
		fixedControls: 'fit',
		overlayOptions: {
			opacity: .75,
			position: 'bottom center',
			hideOnMouseOut: true
		}
	});
</script>

</head>
<body>

<div id="galeria">
<ul>
<?php
//katalog z dużymi obrazkami
$katalog = "obrazki";

//katalog z miniaturkami
$katalogMiniaturki = "miniaturki";

//ilość zdjęć na stronie
$naStronie = 6;

//czy ma być opis zdjęcia - jego numer - true to tak, false to nie
$opisZdjecia = true;

//---------------------------------------------
//ilość zdjęć - liczy pliki w katalogu
$ilosc = count(glob("./$katalog/*"));

//ilość stron
$iloscStron = ceil($ilosc/$naStronie);

//odczyt katalogu z obrazkami
$pliki = glob($katalog.'/*.jpg');
$i = 0;

//utworzenie tablicy z obrazkami
foreach($pliki as $key => $value){
  $tab[$i] = $value;
  $i++;
}

//sortowanie tablicy
sort($tab);

for($i = 0; $i < $ilosc; $i++){

if($opisZdjecia) $opisZdjecia = '<span>Obrazek nr '.$i.'</span>';
  $tablica[$i] = '<li><a href="'.$tab[$i].'" class="highslide" onclick="return hs.expand(this)" title="Obrazek nr '.$i.'"><img width="200" height="133" src="'.str_replace($katalog, $katalogMiniaturki, $tab[$i]).'" alt="Obrazek nr '.$i.'" />'.$opisZdjecia.'</a></li>';
}

//sprawdza aktualny numer strony
if($_GET['strona'] && $_GET['strona'] > 0 && $_GET['strona'] <= $iloscStron) $strona = $_GET['strona']-1;
else $strona = 0;

$poczatek = $strona * $naStronie;
if($poczatek >= $ilosc) $poczatek = 0;

$koniec = $poczatek + $naStronie;
if($koniec >= $ilosc) $koniec = $ilosc;

//generowanie wykazu
for($i = $poczatek; $i < $koniec; ++$i){
  echo $tablica[$i]."\n";
}
?>
</ul>

<ul id="nawigacja">
<?php
//link do poprzedniej strony
if($strona > 0) echo '<li><a href="index.php?strona='.($strona).'" >[<]</a></li>';
for($i = 1; $i <= $iloscStron; ++$i){

//linki do poszczególnych stron
  echo '<li><a href="index.php?strona='.$i.'" >['.$i.']</a></li>';
}
echo $linki;

//link do następnej strony
if($strona < $iloscStron-1) echo '<li><a href="index.php?strona='.($strona+2).'" >[>]</a></li>';
?>
</ul>
</div>

</body>
</html>